<?php
/* --------------------------------------------------------------
 LineBreak.php 2019-12-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Types;

use Gambio\Core\Configuration\Models\Read\Collections\Options;
use Gambio\Core\Configuration\Models\Read\Option;
use Gambio\Core\Configuration\Repositories\Components\OptionsResolver;

/**
 * Class LineBreak
 * @package Gambio\Core\Configuration\Types
 */
class SenderMail implements ConfigurationType
{
    /**
     * @inheritDoc
     */
    public function toOptions(OptionsResolver $resolver, string $value = null): ?Options
    {
        $options = [
            Option::create('CUSTOMER_MAIL', $resolver->getText('GM_CFG_CUSTOMER_MAIL', 'gm_general')),
            Option::create('SHOP_OWNER', $resolver->getText('GM_CFG_SHOP_OWNER', 'gm_general')),
        ];
        
        return Options::create(...$options);
    }
    
    
    /**
     * @inheritDoc
     */
    public function inputType(): string
    {
        return 'dropdown';
    }
}